/*
This file is part of mfaktc.
Copyright (C) 2009, 2010, 2011, 2012  Oliver Weihe (o.weihe@t-online.de)
This file has been written by Luigi Morelli (L.Morelli@mclink.it)

mfaktc is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mfaktc is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                
You should have received a copy of the GNU General Public License
along with mfaktc.  If not, see <http://www.gnu.org/licenses/>.
*/
#if !defined(TRUE)	// keep self-contained
	#define FALSE (0)
	#define TRUE (1)
#endif

enum ASSIGNMENT_ERRORS
{	NEVER_ASSIGNED=-1,
	OK=0,
	CANT_OPEN_FILE=1,
	VALID_ASSIGNMENT_NOT_FOUND=2,
	CANT_OPEN_WORKFILE=3,
	CANT_OPEN_TEMPFILE=4,
	ASSIGNMENT_NOT_FOUND=5,
	CANT_RENAME =6
};
#define MAX_LINE_LENGTH 100
typedef char LINE_BUFFER[MAX_LINE_LENGTH+1];

struct ASSIGNMENT
{
	int type;				// 0 = Mersenne, 1 = Double-Mersenne, 2 = Fermat
	unsigned int exponent;
	int bit_min;
	int bit_max;
	unsigned long long int k_min;
	unsigned long long int k_max;
	char assignment_key[MAX_LINE_LENGTH+1];	// optional assignment key....
	char comment[MAX_LINE_LENGTH+1];	// optional comment.
						// if it has a newline at the end, it was on a line by itself preceding the assignment.
						// otherwise, it followed the assignment on the same line.
};


int valid_assignment(int fermat, unsigned int exp, int bit_min, int bit_max, int verbosity);	// nonzero if assignment is valid
enum ASSIGNMENT_ERRORS get_next_assignment(char *filename, int *fermat_factoring, unsigned int *exponent, int *bit_min, int *bit_max, unsigned long long *k_min, unsigned long long *k_max, LINE_BUFFER *assignment_key, int verbosity);
enum ASSIGNMENT_ERRORS clear_assignment(char *filename, int fermat_factoring, unsigned int exponent, int bit_min, int bit_max, unsigned long long k_min, unsigned long long k_max, int bit_min_new);
